#! /usr/bin/perl -T
# dieses programm macht macht eine anfrage bei der 'entrez' datenbank und parsed daraus die anzahl gefundener eintrge
#  2004-02-17 Felipe Wettstein
# 20027-07-16 Anpassungen an neues entrez-layout
# 

use LWP::Simple;
use strict;
use warnings;


# CGI programs must print their own HTTP response headers
print "Content-type: text/html\n\n";

# die adresse die von der gefragt wird
my $entrezadresse = 'http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Search&db=nucleotide&term=';

# danach wird gesucht
my $suchstring = '((16s[Title] AND rRNA[Title]) OR (16s[Title] AND ribosomal[Title] AND RNA[Title]))';

# eine kopie des strings, bevor er aufbereitet wird
my $suchstring_ohne = $suchstring;

# im suchstring mssen alle leerzeichen durch '+' ersetzt sein
$suchstring =~s/\s/\+/g;

# die ganze erste seite von aus der die zahl genommen wird, hat in $doc platz
my $doc = get($entrezadresse.$suchstring); 

# schon mal n' header drucken
print <<EOF;
<HTML>
<HEAD>
<META CONTENT="text/html; charset=ISO-8859-1" HTTP-EQUIV="Content-Type">
EOF

# es interessiert nur die zeile mit: 
# div><div class="found"><h2>Found 497211 nucleotide sequences</h2>
if ($doc =~ /\<h2\>Found\s*(\d*)/) {
	
print <<EOF;
<TITLE>$1</TITLE></HEAD>
<BODY>
<h1>$1 16S rDNA</h1>
Eintr&auml;ge in '<a href="http://www.ncbi.nlm.nih.gov:80/Database/index.html">Nucleotide</a>' bei 
<a href="http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?">Entrez</a>.<br> Suchstring: $suchstring_ohne
</body></html>
EOF

} else {
print <<EOF;
<TITLE>Hat nicht geklappt.</TITLE></HEAD>
<BODY>
<h1>Irgendwas gieng schief.</h1>
$1
</body></html>
EOF
}
exit 0;
